<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use Illuminate\Support\Facades\DB;

class UsersToAssetsRatioRepository
{

    protected $assetModel;

    /**
     * Constructor for the class.
     *
     * @param Asset $assetModel The asset model instance.
     */
    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
    }


    /**
     * Retrieves the asset type data associated with user data.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function getAssetTypeToUserData()
    {
        return $this->assetModel->select('assets.*')->with(
                'location:id,room_name', 'user:id,first_name,last_name,email,employee_id,city,position_id,department_id,legalhold,hire_date,terminated_date,status',
                'user.position:id,name', 'user.department:id,name', 
                'assetType:id,name', 'makeAndModel:id,name,manufacturer_id', 'makeAndModel.manufacturer:id,name', 'technicalSpec:id,details', 
                'assetStatus:id,name', 'carrier:id,name', 'parentAsset:id,asset_tag', 'latestAssetHistory:id,asset_id,updated_at,user_id', 
                'latestAssetHistory.user:id,first_name,last_name', 'workspaceOne:id,asset_id,last_seen')
            ->leftJoin('users', 'users.id', '=', 'assets.user_id');
    }

    /**
     * Retrieves the formatted data of asset types associated with users.
     *
     * This function queries the asset model and selects the count of all assets,
     * and also eager loads the associated user model. The result is returned.
     *
     * @return Builder The query builder object.
     */
    public function getAssetTypeToUserFormattedData()
    {
        return $this->assetModel->select(DB::raw('count(*) as cnt'))->with('user');
    }
}