<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use Carbon\Carbon;

class UpcomingRefreshRepository
{
    
    protected $assetModel;

    /**
     * Constructs a new instance of the class.
     *
     * @param Asset $assetModel The asset model.
     */
    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
    }
    
    
    
    /**
     * get query for all assets greater than 2.5 years old
     * @return [type]
     */
    public function getUpcomingRefreshAssets()
    {
        $date = Carbon::now()->subYears(2.5)->format('Y-m-d H:i:s');
        $assets = $this->assetModel->select('assets.*')->with(
            'location:id,room_name', 'user:id,first_name,last_name,department_id,city', 'user.department:id,name','assetType:id,name,slug', 
            'makeAndModel:id,name,manufacturer_id', 'makeAndModel.manufacturer:id,name', 
            'technicalSpec:id,details,original_value','assetStatus:id,name,slug', 
            'latestAssetHistory:id,asset_id,user_id,updated_at','latestAssetHistory.user:id,first_name,last_name'
            )
            ->leftJoin('users', 'users.id', '=', 'assets.user_id')
            ->whereHas('assetType', function ($query) {
                $query->whereIn('slug', config('reports.upcoming_refresh.include_asset_types'));
            })
            ->whereHas('assetStatus', function ($query) {
                $query->whereIn('slug', ['assigned', 'loaned']);
            })
            ->where('assets.created_at', '<=', $date);
        return $assets;
    }
}
