<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use App\Models\AssetStatus;
use Illuminate\Support\Facades\DB;

class LostOrStolenValueRepository
{
    
    protected $assetModel;

    /**
     * Constructs a new instance of the class.
     *
     * @param Asset $assetModel The asset model.
     */
    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
        $this->lostOrStolenAssetStatus = $this->getLostOrStolenAssetStatus();
    }
    
    
    
    /**
     * get query for all lost/stolen assets
     * @return [type]
     */
    public function getLostOrStolenValueAssets()
    {
        $assets = $this->assetModel->with('location', 'user', 'assetType', 'makeAndModel.manufacturer', 'assetStatus', 'assetHistory', 'latestLostOrStolenAssetHistory')
            ->where('asset_status_id', $this->lostOrStolenAssetStatus);
        return $assets;
    }

    /**
     * Pre defiend lost/stolen status 
     * @return [type]
     */
    public function getLostOrStolenAssetStatus()
    {
        return optional(AssetStatus::where('slug', 'stolen_lost')->first())->id;
    }

}
