<?php

namespace App\Repositories\Reports;

use App\Models\Asset;

class ComputerDeployedRepository
{

    protected $assetModel;

    /**
     * Constructor for the class.
     *
     * @param Asset $assetModel The asset model object.
     */
    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
    }



    /**
    * fetch asset data
    * @params
    * @return Asset
    * */
    public function getAssetsData()
    {
        return $this->assetModel->hasAnyAssetStatus(['assigned', 'installed'])->with(
            'location:id,room_name', 'user:id,first_name,last_name,city', 
            'makeAndModel:id,name,manufacturer_id', 'technicalSpec:id,details',
			'makeAndModel.manufacturer:id,name','latestAssignedOrInstalledAssetHistory'
        )
        ->select('assets.*')
        ->orderBy('assets.created_at');
    }
}
