<?php

namespace App\Repositories\Reports;

use App\Models\Asset;

class ComputerByStatusRepository
{
    protected $model;

    /**
     * Constructor for the class.
     *
     * @param Asset $model The model for the class.
     */
    public function __construct(Asset $model)
    {
        $this->model = $model;
    }

    /**
     * Retrieves the data from the specified model along with its related entities.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function getData()
    {
        return $this->model::with('location', 'user', 'assetType', 'carrier', 'makeAndModel.manufacturer', 'technicalSpec', 'assetStatus', 'parentAsset', 'childrenAsset', 'latestAssetHistory.user');
    }

    /**
     * Filters the query by manufacturer.
     *
     * @param mixed $query The query to filter.
     * @param string|array $manufacturer The manufacturer(s) to filter by.
     * @return mixed The filtered query.
     */
    public function filterWithManufacturer($query, string $manufacturer)
    {
        if ($manufacturer) {
            $query = $query->whereHas('makeAndModel.manufacturer', function ($makeAndModelQuery) use ($manufacturer) {
                if (is_array($manufacturer)) {
                    $makeAndModelQuery->whereIn('id', $manufacturer);
                } else {
                    $makeAndModelQuery->where('id', $manufacturer);
                }
            });
        }

        return $query;
    }
}