<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use Carbon\Carbon;

class ComputerByAgeRepository
{
	public function __construct(protected Asset $model)
	{
		$this->model = $model;
	}
	/**
	 * Making query for 'Computer Aged out' report
	 */
	public function getData()
	{
		$excludedStatuses = config('reports.common_reports.exclude_statuses');

		return $this->model::with(
			'user:id,first_name,last_name,location_id,city', 'location:id,room_name', 'assetStatus:id,name', 
			'makeAndModel:id,name,manufacturer_id', 'technicalSpec:id,details',
			'makeAndModel.manufacturer:id,name'
			)
			->isComputer()->doesNotHaveAssetStatus($excludedStatuses);
	}
}
