<?php

namespace App\Repositories\Reports;

use App\Models\AssetHistory;
use App\Models\AssetStatus;

class BrandNewToAssignedRepository
{

    protected $assetStatusModel;
    protected $assetHistoryModel;

    /**
     * Constructor for the class.
     *
     * @param AssetStatus $assetStatusModel The asset status model.
     * @param AssetHistory $assetHistoryModel The asset status model.
     */
    public function __construct(AssetStatus $assetStatusModel, AssetHistory $assetHistoryModel)
    {
        $this->assetStatusModel = $assetStatusModel;
        $this->assetHistoryModel = $assetHistoryModel;
    }


    /**
	 * Generate Query for assets changed from brandnew to assigned with in a date range
	 * @param string $dateFrom
	 * @param string $dateTo
	 * @return \Illuminate\Database\Eloquent\Builder query
	 */
	public function getAssetsChangedFromBrandNewToAssigned($dateFrom, $dateTo)
	{
        $brandNewStatusId = $this->assetStatusModel::getStatusID('brand_new')->first()->id;
		$assignedStatusId = $this->assetStatusModel::getStatusID('assigned')->first()->id;

        $assetHistory = $this->assetHistoryModel::whereHas('asset', function ($query) {
            $query->whereHas('assetType', function ($query) {
				$query->whereNotIn('slug', ['mobile_phone_number']);
            });
        })
        ->with(
            'asset.assetType:id,name', 'asset.makeAndModel:id,name,manufacturer_id', 
            'asset.makeAndModel.manufacturer:id,name','asset.technicalSpec:id,details',
            'newUser:id,first_name,last_name,position_id','newUser.position:id,name',
            'newUser:id,first_name,last_name,position_id','newUser.position:id,name',
            'oldLocation:id,room_name'
        )
        ->where('action', '=', 'status_updated')
        ->where('old_asset_status_id', '=', $brandNewStatusId)
        ->where('new_asset_status_id', '=', $assignedStatusId)
        ->where('created_at', '>=', $dateFrom)
		->where('created_at', '<=', $dateTo);
        

        return $assetHistory;
	}

}