<?php

namespace App\Repositories\Reports;

use App\Models\AssetHistory;
use App\Models\AssetStatus;

class BrandNewAssignedToContractorRepository
{
    protected $assetHistoryModel;
    protected $assetStatusModel;

    /**
     * Constructor for the class.
     *
     * @param AssetHistory $assetHistoryModel description
     * @param AssetStatus $assetStatusModel description
     */
    public function __construct(AssetHistory $assetHistoryModel, AssetStatus $assetStatusModel)
    {
        $this->assetHistoryModel = $assetHistoryModel;
        $this->assetStatusModel = $assetStatusModel;
    }

	/**
	 * Get asset history changed from brand new assigned to contractor.
	 *
	 * @param datatype $dateFrom description
	 * @param datatype $dateTo description
	 * @return Builder
	 */
	public function getAssetsChangedFromBrandNewAssignedToContractor($dateFrom, $dateTo)
	{
        $brandNewStatusId = $this->assetStatusModel::getStatusID('brand_new')->first()->id;
		$assignedStatusId = $this->assetStatusModel::getStatusID('assigned')->first()->id;

        $assetHistory = $this->assetHistoryModel::whereHas('asset', function ($query) {
            $query->whereHas('assetType', function ($query) {
                $query->whereNotIn('slug', ['mobile_phone_number']);
            });
        })
        ->with('newUser:id,first_name,last_name,position_id', 'newUser.position:id,name', 'oldLocation:id,room_name')
        ->where('action', '=', 'status_updated')
        ->where('old_asset_status_id', '=', $brandNewStatusId)
        ->where('new_asset_status_id', '=', $assignedStatusId)
        ->where('created_at', '>=', $dateFrom)
		->where('created_at', '<=', $dateTo)
        ->whereHas('newUser', function ($query) {
            $query->whereHas('employeeType', function ($employeeQuery) {
                $employeeQuery->where('slug', 'contractor');
            });
        });

        return $assetHistory;
	}
}
