<?php

namespace App\Repositories\Reports;

use App\Models\AssetHistory;
use App\Models\AssetStatus;
use DB;

class AverageTimeInBrandNewRepository
{
    
    protected $assetStatusModel; 
    protected $assetHistoryModel;

    /**
     * Constructor for the class.
     *
     * @param AssetStatus $assetStatusModel The AssetStatus model.
     * @param AssetHistory $assetHistoryModel The AssetHistory model.
     */
    public function __construct(AssetStatus $assetStatusModel, AssetHistory $assetHistoryModel)
    {
        $this->assetStatusModel = $assetStatusModel;
        $this->assetHistoryModel = $assetHistoryModel;
    }
    
    /**
     * get total count of assets and  total days of a assets move from brand new to assigned in each month of a year
     * @param Int $year
     * @return Array $resultData
     */
    public function getMonthlyAvgTimeFromBrandNewToAssignedInYear($year)
    {
        $brandNewStatusId = $this->assetStatusModel->getStatusID('brand_new')->first()->id;
		$assignedStatusId = $this->assetStatusModel->getStatusID('assigned')->first()->id;
        
        return $this->assetHistoryModel->select(
            DB::raw("CONCAT(YEAR(asset_histories.created_at), '-', MONTH(asset_histories.created_at)) as yearMonth"),
            DB::raw("MONTH(asset_histories.created_at) as month"),
            DB::raw('ROUND(AVG(CASE WHEN  DATEDIFF(a2.created_at, asset_histories.created_at) > 0 then DATEDIFF(a2.created_at, asset_histories.created_at) end)) as avg_time')
        )
        ->join('asset_histories as a2', 'a2.asset_id', '=', 'asset_histories.asset_id')
        ->where('asset_histories.new_asset_status_id', '=', $brandNewStatusId)
        ->where('a2.new_asset_status_id', '=', $assignedStatusId)
        ->whereRaw('a2.created_at > asset_histories.created_at')
        ->whereRaw('YEAR(a2.created_at) = YEAR(asset_histories.created_at)')
        ->whereRaw('YEAR(asset_histories.created_at) ='.$year)
        ->groupByRaw('YEAR(asset_histories.created_at)')
        ->groupByRaw('MONTH(asset_histories.created_at)')
        ->havingRaw('avg_time > 0')
        ->get()
        ->toArray();
    }
}
