<?php

namespace App\Repositories\Reports;

use App\Models\Location;
use DB;

class AvailableStockRepository
{

    protected $locationModel;

    /**
     * Constructor for the class.
     *
     * @param Location $locationModel The location model object.
     */
    public function __construct(Location $locationModel)
    {
        $this->locationModel = $locationModel;
    }


    /**
     * Making query to get Available stock in inventory
     *
     * @return object
     */
    public function getAvailableStockDetails()
    {
        return $this->locationModel->warehouses()
            ->select('locations.id as location_id','locations.status as location_status','locations.room_name as location', 'countries.name as country', 'regions.name as region', 'asset_statuses.name as status', 'asset_types.name as type', 'manufacturers.name as manufacturer', 'make_and_models.name as model', 'technical_specs.details as tech_specs', DB::raw('COUNT(assets.id) as asset_count'), 'site_codes.code as site_code')
            ->join('assets', 'assets.location_id', '=', 'locations.id')
            ->join('asset_statuses', 'assets.asset_status_id', '=', 'asset_statuses.id')
            ->join('asset_types', 'assets.asset_type_id', '=', 'asset_types.id')
            ->join('make_and_models', 'assets.make_and_model_id', '=', 'make_and_models.id')
            ->join('manufacturers', 'manufacturers.id', '=', 'make_and_models.manufacturer_id')
            ->leftJoin('technical_specs', 'assets.technical_spec_id', '=', 'technical_specs.id')
            ->leftJoin('countries', 'countries.id', '=', 'locations.country_id')
            ->leftJoin('regions', 'regions.id', '=', 'locations.region_id')
            ->leftJoin('site_codes', 'site_codes.id', '=', 'locations.site_code_id')
            ->whereIn('asset_statuses.slug', config('reports.available-stock.include_statuses'))
            ->groupBy('locations.id','asset_statuses.id','asset_types.id','make_and_models.id','technical_specs.id');
    }


    /**
     * making query to filter with attributes
     *
     * @param object $query
     * @param string $field
     * @param  mixed $value
     * @param mixed $hardwareStandard
     *
     * @return object
     */
    public function filterTechRelation($query, $field, $value, $hardwareStandard)
	{
        if ($value != null) {

            if (!empty($hardwareStandard)) {
                if(is_array($hardwareStandard)) {
                    $query->whereIn('assets.make_and_model_id', $hardwareStandard);
                } else {
                    $query->where('assets.make_and_model_id', $hardwareStandard);
                }
            }

            if(is_array($value)) {
               return $query->whereIn($field, $value);
            }
            return $query->where($field, $value);
        }

        return $query;
	}
}
