<?php

namespace App\Repositories\Reports;

use App\Models\AssetHistory;
use App\Models\AssetStatus;
use DB;

class AssetsInTheStatusByMonthRepository
{
    
    protected $assetStatusModel; 
    protected $assetHistoryModel;

    /**
     * Constructor for the class.
     *
     * @param AssetStatus $assetStatusModel The AssetStatus model.
     * @param AssetHistory $assetHistoryModel The AssetHistory model.
     */
    public function __construct(AssetStatus $assetStatusModel, AssetHistory $assetHistoryModel)
    {
        $this->assetStatusModel = $assetStatusModel;
        $this->assetHistoryModel = $assetHistoryModel;
    }

    /**
     * get assets in 'Brand New', 'Used' and 'assigned' status in a year
     * @param string $dateFrom
	 * @param string $dateTo
     * @return object $query
     */
    public function getAssetsListInInStatusesInYear($dateFrom, $dateTo)
    {
        $assetStatusesToCheck = $this->assetStatusModel->getNameFromSlug(['brand_new', 'used', 'assigned'])->pluck('id')->toArray();

        $query = $this->assetHistoryModel->whereHas('newStatus', function ($query) use ($assetStatusesToCheck) {
            $query->whereIn('id', $assetStatusesToCheck);
        })
        ->with(
            'newStatus:id,name',
            'asset:id,asset_tag,serial_no,asset_type_id,make_and_model_id,technical_spec_id,asset_status_id',
            'asset.assetType:id,name', 'asset.assetStatus:id,name', 'asset.makeAndModel:id,name,manufacturer_id',
            'asset.makeAndModel.manufacturer:id,name', 'asset.technicalSpec:id,details'
        )
        ->where('created_at', '>=', $dateFrom)
		->where('created_at', '<=', $dateTo);

        return $query;
    }

    /**
     * Retrieves the select query for assets.
     *
     * @param object $query description
     * 
     * @return object
     */
    public function getAssetsSelectQuery($query)
    {
        $assignedStatus = $this->assetStatusModel->getNameFromSlug('assigned')->value('id');
        $brandNewandUsedStatuses = $this->assetStatusModel->getNameFromSlug(['brand_new', 'used',])->pluck('id')->toArray();
        
        $query = $query->select(
            DB::raw("MONTH(asset_histories.created_at) as month"),
            DB::raw('SUM(CASE WHEN asset_histories.new_asset_status_id = '.$assignedStatus.' THEN 1 ELSE 0 END) AS assigned_count'),
            DB::raw('SUM(CASE WHEN asset_histories.new_asset_status_id IN (' . implode(',', $brandNewandUsedStatuses) . ') THEN 1 ELSE 0 END) AS brandnew_and_used_count')
        )
        ->groupByRaw('MONTH(asset_histories.created_at)')->get()->toArray();

        return $query;

    }
}
