<?php

namespace App\Repositories\Reports;

use App\Models\Asset;

/**
 * AssetsByWarranty - Repository for warranty reports
 */
class AssetsCreatedRepository
{
    
    protected $assetModel;
    
    public function __construct(Asset $assetModel) 
    {
        $this->assetModel =  $assetModel;
    }

    /**
     * Get asset created data between two dates.
     *
     * @param $dateFrom
     * @param $dateTo
     * @return mixed
     */
    public function getAssetCreatedData($dateFrom, $dateTo)
    {
        return $this->assetModel->with('assetType:id,name', 'location:id,room_name', 'user:id,first_name,last_name', 'makeAndModel.manufacturer:id,name', 'technicalSpec:id,details')
                    ->whereBetween('created_at', [$dateFrom, $dateTo]);
    }

    /**
     * Get the select query for counting created assets.
     *
     * @param QueryBuilder $query The query builder instance
     * @return QueryBuilder
     */
    public function getAssetCreatedCountSelectQuery($query)
    {
        return $query->select('id', 'created_at', 'asset_type_id');
    }
}