<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use Carbon\Carbon;

class AssetRecoveryValueRepository
{
    
    protected $assetModel;

    /**
     * Constructs a new instance of the class.
     *
     * @param Asset $assetModel The asset model.
     */
    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
    }
    
    
    
    /**
     * get query for all assets greater than 3 years old
     * @return [type]
     */
    public function getRecoveryAssets()
    {
        $date = Carbon::now()->subYears(3)->format('Y-m-d');
        $assets = $this->assetModel->with(
            'location:id,room_name', 'user:id,first_name,last_name', 'assetType:id,name,slug', 
            'makeAndModel:id,name,manufacturer_id', 'makeAndModel.manufacturer:id,name', 
            'technicalSpec:id,details,original_value','assetStatus:id,name,slug'
        )
            ->whereHas('assetType', function ($query) {
                $query->whereIn('slug', config('reports.asset_recovery_value.include_asset_types'));
            })
            ->whereHas('assetStatus', function ($query) {
                $query->whereIn('slug', config('reports.asset_recovery_value.include_statuses'));
            })
            ->whereDate('assets.created_at', '<=', $date);
        return $assets;
    }
    
}
