<?php 

namespace App\Repositories\Reports;

use App\User;
use Illuminate\Support\Facades\DB;

class ActiveUsersRepository
{

    protected $userModel;
    
    /**
     * Constructor for the class.
     *
     * @param User $userModel
     * 
     */
    public function __construct(User $userModel)
    {
        $this->userModel = $userModel;
    }
    
    /**
     * Making query for `Active Users with No Assets Assigned` report
     *
     * @return App\User
     */
    public function getActiveUsersWithNoAssets()
    {
        return $this->userModel->superAdmin()
            ->active()
            ->with(['department:id,name', 'manager:id,first_name,last_name,email'])
            ->doesntHave('assets');
    }

    /**
     * Searches for users with general queries.
     *
     * @param $users The users to search in.
     * @param $searchTerm The text to search for.
     * @return The filtered users.
     */
    public function searchUserWithGeneralQueries($users, $searchTerm)
    {
        if ($searchTerm) {
            $users = $users->where(function ($query) use ($searchTerm) {
                $query->where(function ($query) use ($searchTerm) {
                    $query->where('first_name', 'like', $searchTerm . '%')
                        ->orWhere('last_name', 'like', $searchTerm . '%')
                        ->orWhere('employee_id', $searchTerm)
                        ->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) like ?", [$searchTerm . '%'])
                        ->orWhere('email', 'like', $searchTerm . '%');
                })
                    ->orWhereHas('position', function ($query) use ($searchTerm) {
                        $query->where('name', 'like', '%' . $searchTerm . '%');
                    })
                    ->orWhereHas('employeeType', function ($query) use ($searchTerm) {
                        $query->where('name', 'like', '%' . $searchTerm . '%');
                    })
                    ->orWhereHas('department', function ($query) use ($searchTerm) {
                        $query->where('name', 'like', '%' . $searchTerm . '%');
                    })
                    ->orWhere('city', 'like', '%' . $searchTerm . '%');
            });
        }

        return $users;
    }
}