<?php

namespace App\Repositories\OsCompliance;

use App\Models\IntuneComputer;
use App\Models\OperatingSystemComplianceSettings;
use Illuminate\Support\Str;

class WindowsOsComplianceRepository extends AbstractOsComplianceRepository
{
    /**
     * Making query for Intune devices with non compliant os version or platform
     * @param OperatingSystemComplianceSettings $settings
     */
    public function getNonOsCompliantDevicesFromIntune($settings = '')
    {
        $assets = IntuneComputer::select(
            'intune_computers.id', 'intune_computers.asset_id', 'intune_computers.checkin_date', 'intune_computers.user_id', 'intune_computers.user_name', 'intune_computers.serial_no', 'intune_computers.platform', 'intune_computers.os_version', 'intune_computers.model', 'intune_computers.manufacturer'
            )
            ->with(
                'asset:id,serial_no,asset_type_id,make_and_model_id,technical_spec_id,asset_status_id,user_id,location_id', 
                'asset.assetType:id,name','asset.makeAndModel:id,name','asset.technicalSpec:id,details','asset.assetStatus:id,name',
                'asset.user:id,first_name,last_name','asset.location:id,room_name'
            )
            ->join('assets', 'assets.serial_no', '=', 'intune_computers.serial_no');
        $assets = $this->filterWithOsComplianceSettings($assets, $settings);
        return $assets;
    }

    /**
     * Making query for Intune devices with outdated os version.
     */
    public function getDevicesWithOutdatedOSFromIntune()
    {
        $settings = OperatingSystemComplianceSettings::select('os_version')->where('device_type', 'windows')->first();
        $assets = IntuneComputer::select('intune_computers.id', 'intune_computers.asset_id', 'intune_computers.checkin_date', 'intune_computers.user_id', 'intune_computers.user_name', 'intune_computers.serial_no', 'intune_computers.platform', 'intune_computers.os_version', 'intune_computers.model', 'intune_computers.manufacturer')
            ->with('asset', 'user')
            ->join('assets', 'assets.serial_no', '=', 'intune_computers.serial_no');
        $assets = $this->filterWithOutdatedOS($assets, $settings);
        return $assets;
    }
}
