<?php

namespace App\Repositories\OsCompliance;

use App\Models\AssetType;
use App\Models\KandjiDevices;
use App\Models\OperatingSystemComplianceSettings;
use App\Repositories\DiscoveryTools\KandjiRepository;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class KandjiComplianceRepository extends AbstractOsComplianceRepository
{
    protected $kandjiRepository;

    public function __construct()
    {
        $this->kandjiRepository = new KandjiRepository;
    }

    /**
     * Making query for Workspace ONE devices with non compliant os version or platform
     * @param OperatingSystemComplianceSettings $settings
     */
    public function getDevices()
    {
        $assets =  KandjiDevices::select('kandji_devices.id', 'kandji_devices.serial_no', 'kandji_devices.model', 'platform', 'kandji_devices.os_version', 'kandji_devices.asset_id', 'kandji_devices.last_checkin as last_seen', 'kandji_devices.user_id', 'kandji_devices.user_name', 'kandji_devices.email')
            ->with('asset', 'user')
            ->join('assets', 'assets.serial_no', '=', 'kandji_devices.serial_no')
            ->whereNotIn('platform', ['Windows', 'WinRT', 'ChromeOS']);
        return $assets;
    }

    /**
     * Making query for filtering android devices
     * @param Query $assets
     */
    public function filterAndroidDevices($assets)
    {
        return $assets->where('platform', '=', 'Android');
    }

    /**
     * Making the query for filtering apple devices from Kandji
     */
    public function filterAppleDevices($assets, $inputData)
    {
        $assets = $assets->RelationData($inputData['mdm_serial_no'], 'kandji_devices.serial_no');
        $assets = $assets->RelationData($inputData['model'], 'kandji_devices.model');
        $assets = $assets->RelationData($inputData['user'], 'kandji_devices.email');
        $assets = $this->kandjiRepository->filterWithLastCheckIn($assets, $inputData['checkinFrom'], $inputData['checkinTo']);
        // $assets = $assets->RelationData($inputData['platform'], 'kandji_devices.platform');
        $assets = $assets->RelationData($inputData['os_version'], 'kandji_devices.os_version');
        $assets = $this->filterAssets($assets, $inputData);

        return $assets;
    }

    /**
     * fetch kandji filter values for report
     * @param string $type kandji attribute name
     */
    public function getFilterData($type)
    {
        return KandjiDevices::select("$type")->whereNotIn('platform', ['Windows', 'WinRT', 'ChromeOS'])->groupBy($type)->get()->filter();
    }
}
