<?php

namespace App\Repositories\OsCompliance;

use App\Models\Chromebook;
use App\Models\OperatingSystemComplianceSettings;
use Illuminate\Support\Str;

class ChromebookOsComplianceRepository extends AbstractOsComplianceRepository
{
    /**
     * Making query for Chromebook devices with non compliant os version or platform
     * @param OperatingSystemComplianceSettings $settings
     */
    public function getNonOsCompliantDevicesFromChrome($settings = '')
    {
        $assets =  Chromebook::select('chromebooks.id', 'chromebooks.user_id', 'chromebooks.serial_no', 'chromebooks.model', 'chromebooks.asset_id', 'chromebooks.user_id', 'chromebooks.email', 'chromebooks.last_sync', 'chromebooks.platform', 'chromebooks.os_version', 'chromebooks.model')
            ->with(
                'asset:serial_no,asset_type_id,make_and_model_id,technical_spec_id,asset_status_id,user_id,location_id', 
                'asset.assetType:id,name','asset.makeAndModel:id,name','asset.technicalSpec:id,details','asset.assetStatus:id,name',
                'asset.User:id,first_name,last_name','asset.location:id,room_name,'
            )
            ->join('assets', 'assets.serial_no', '=', 'chromebooks.serial_no');
        $assets = $this->filterWithOsComplianceSettings($assets, $settings);
        return $assets;
    }


    /**
     * Making query for Chromebook devices with outdated os version.
     */
    public function getDevicesWithOutdatedOsFromChrome()
    {
        $settings = OperatingSystemComplianceSettings::select('os_version')->where('device_type', 'chrome')->first();
        $assets = Chromebook::select('chromebooks.id', 'chromebooks.user_id', 'chromebooks.serial_no', 'chromebooks.model', 'chromebooks.asset_id', 'chromebooks.user_id', 'chromebooks.email', 'chromebooks.last_sync', 'chromebooks.platform', 'chromebooks.os_version', 'chromebooks.model')
            ->with('asset', 'user')
            ->join('assets', 'assets.serial_no', '=', 'chromebooks.serial_no');
        $assets = $this->filterWithOutdatedOS($assets, $settings);
        return $assets;
    }
}
