<?php

namespace App\Repositories\NewHire;

use App\Models\Asset;
use DB;
use Carbon\Carbon;
use App\Models\AssetStatus;
use App\Models\DepartmentHardwareMapping;

use function Clue\StreamFilter\fun;

class NewHireForecastingRepository
{
    /**
     * Based on newhires in each department, select count of totalAssetwithrequired hardwarestandards,select already TotalassignedAssetWithrequiredhardwarestandards,
     * select TotalAvailableAssetWithrequiredhardwarestandards and cost
     * view
     */
    public function getNewHireForcastingData()
    {
        return DepartmentHardwareMapping::with(['makeAndModel:id,name', 'technicalSpec:id,details', 'newhireUsers'])
            ->withCount('inStockAssets as totalassets')->has('newhireUsers', '>', 0);

        // dd($userDatas->first()->department[0]->user->pluck('id'));

    }

    /**
     * @return A collection of DepartmentHardwareMapping objects.
     */
    public function getDepartmentHardwareData()
    {
        return  DepartmentHardwareMapping::with('makeAndModel:id,name', 'technicalSpec:id,details', 'newhireUsers')
            ->withCount('newhireUsers')
            ->withCount('inStockAssets')
            ->has('newhireUsers', '>', 0);
    }

    /**
     * > It takes in a collection, a field name, and a field value, and returns a collection filtered
     * by the field name and value
     *
     * @param newhireData The collection of data you want to filter
     * @param fieldName The name of the field you want to filter by.
     * @param fieldValue The value of the field you want to filter by.
     */
    public function filterWithHardwareKitData($newhireData, $fieldName, $fieldValue)
    {
        return $newhireData->when(
            $fieldValue ?? false,
            function ($newhireData) use ($fieldName, $fieldValue) {
                return is_array($fieldValue) ? $newhireData->whereIn($fieldName, $fieldValue) : $newhireData->where($fieldName, $fieldValue);
            }
        );
    }
}
