<?php

namespace App\Repositories;

use App\Models\MakeAndModel;
use App\Models\TechnicalSpecs;
use App\User;
use Illuminate\Support\Facades\DB;

class FilterFieldRepository
{
	/**
	 * get teqtivity users based on search
	 *
	 * @param string $search  search value
	 *
	 * @return filtered query
	 */
	public function getTeqtivityUsers($search)
	{
		$res = User::teqtivityUser()
			->where(function ($query) use ($search) {
				$query->where('first_name', 'like', $search . '%')
					->orWhere('last_name', 'like', $search . '%')
					->orWhereRaw("CONCAT(`first_name`, ' ', `last_name`) like ?", [$search . '%'])
					->orWhere('email', 'like', $search . '%');
			});
		if (request()->has('current_user_id') && !empty(request('current_user_id'))) {
			$res = $res->where('id', '!=', request('current_user_id'));
		}

		return $res->limit(15)->get();
	}

	/**
	 * Retrieves technical specification data.
	 *
	 * @return mixed
	 */
	public function getTechnicalSpecData()
	{
		return TechnicalSpecs::select(
			'technical_specs.id',
			'technical_specs.details as name',
			'make_and_models.id as make_and_model_id',
			'make_and_models.asset_type_id',
			'make_and_models.manufacturer_id'
		)->join('make_and_models', 'technical_specs.make_and_model_id', '=', 'make_and_models.id')
			->orderBy('technical_specs.details', 'ASC');
	}

	/**
	 * Retrieves hardware standard data.
	 *
	 * @return mixed
	 */
	public function getHardwareStandardData()
	{
		return MakeAndModel::orderBy('name', 'ASC');
	}

	/**
	 * Retrieves all users.
	 *
	 * @return \Illuminate\Database\Eloquent\Collection
	 */
	public function getAllUsers()
	{
		return  User::select('id', 'first_name', 'last_name', 'email')->orderBy('first_name', 'asc');
	}
}
