<?php

namespace App\Repositories\Dashboard;

use App\Models\Asset;
use App\Models\AssetVulnerability;
use App\Models\EolWipedCheckingInAssetsCount;
use App\Models\LockStatus;
use DB;

class ComplianceDashboardRepository
{
    protected  $lockedStatusId;
    public function __construct()
    {
        $this->lockedStatusId = LockStatus::where('slug', 'lock_confirmed')->pluck('id');
    }
    /**
     * Making query to get the count of  devices that are marked as lost/stolen but there is no unlock code from mdm
     * for the asset types laptop, desktops, tablets, mobiles
     */
    public function getLostOrStolenNotLockedCount($type)
    {
        $assetsCount = Asset::whereHas('assetStatus', function ($query) {
            $query->where('slug', 'stolen_lost');
        })
            ->whereNotIn('lock_status_id', $this->lockedStatusId)
            ->whereHas('assetType', function ($query) use ($type) {
                $query->where('slug', $type);
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are marked as lost/stolen but there is no unlock code from mdm
     * for chromebooks
     */
    public function getLostOrStolenNotLockedChromebooksCount()
    {
        $assetsCount = Asset::whereHas('assetStatus', function ($query) {
            $query->where('slug', 'stolen_lost');
        })
            ->whereNotIn('lock_status_id', $this->lockedStatusId)
            ->whereHas('makeAndModel', function ($query) {
                $query->where('slug', 'like', '%chromebook%');
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are not in Workspace One, Intune, ChromeMDM etc
     * for the asset types laptop, desktops, tablets, mobiles
     */
    public function getNotInMDMCount($type)
    {
        $assetsCount = Asset::hasNoDiscoveryAssets()
            ->whereHas('assetType', function ($query) use ($type) {
                $query->where('slug', $type);
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are not in Workspace One, Intune, ChromeMDM etc
     * for chromebooks
     */
    public function getNotInMDMChromebooksCount()
    {
        $assetsCount = Asset::hasNoDiscoveryAssets()
            ->whereHas('makeAndModel', function ($query) {
                $query->where('slug', 'like', '%chromebook%');
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are EOL Wiped status but there is no certificate uploaded
     * for the asset types laptop, desktops, tablets, mobiles
     */
    public function getEOLWipedWithoutCODDCount($type)
    {
        $assetsCount = Asset::whereHas('assetStatus', function ($query) {
            $query->where('slug', 'end_of_life_data_wiped');
        })
            ->whereNull('ewaste_certificate')
            ->whereHas('assetType', function ($query) use ($type) {
                $query->where('slug', $type);
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are EOL Wiped status but there is no certificate uploaded
     * for chromebooks
     */
    public function getEOLWipedWithoutCODDChromebooksCount()
    {
        $assetsCount = Asset::whereHas('assetStatus', function ($query) {
            $query->where('slug', 'end_of_life_data_wiped');
        })
            ->whereNull('ewaste_certificate')
            ->whereHas('makeAndModel', function ($query) {
                $query->where('slug', 'like', '%chromebook%');
            })->count();
        return $assetsCount;
    }

    /**
     * Making query to get the count of  devices that are EOL Wiped status but they are checking in
     *
     */
    function  getEOLWipedCheckingInData()
    {

        $data = EolWipedCheckingInAssetsCount::get();
        return $data;
    }

    /**
     * Retrieves the count of assets detected by the sensor of the specified type.
     *
     * @param string $type The type of the sensor.
     * @return int The count of assets installed sensor.
     */
    public function getSensorDetectedAssetsCount($type)
    {
        $assetsCount = Asset::whereHas('assetType', function ($query) use($type) {
            $query->where('slug', $type);
        })
        ->whereNotNull('crowdstrike_id')
        ->count();
        
        return $assetsCount;
    }

    /**
     * Retrieves the count of vulnerabilities of a specific type.
     *
     * @param string $type The type of vulnerabilities to count.
     * @return int The count of vulnerabilities.
     */
    public function getVulnerabilityCount($type)
    {
        $vulnerabilityCount = AssetVulnerability::where('exprt_rating', $type)
            ->count();
        
        return $vulnerabilityCount;
    }
}
