<?php

namespace App\Repositories\CloudAssets;

use App\Models\CloudAsset;

class CloudAssetRepository
{
    protected $model;

    /**
     * Constructor for the CloudAsset class.
     *
     * @param CloudAsset $model The CloudAsset model
     */
    public function __construct(CloudAsset $model)
    {
        $this->model = $model;
    }

    /**
     * Get the data from the model.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function getData()
    {
        return $this->model::query();
    }

    /**
     * Retrieves search field data based on the provided field and search string.
     *
     * @param string $field The field on which to perform the search
     * @param string $search The search string
     * @return Illuminate\Support\Collection
     */
    public function getFilterFieldData(string $field, string $search)
    {
        return $this->model::select("$field")->where("$field", 'like', '%' . $search . '%')->groupBy($field)->get();
    }
}