<?php

namespace App\Repositories;

use App\Models\Asset;
use App\Models\AssetStatus;
use App\Models\AssetTracking;
use App\Models\AssetType;
use App\Models\Carrier;
use App\Models\Country;
use App\Models\Department;
use App\Models\EmployeePosition;
use App\Models\EmployeeType;
use App\Models\Location;
use App\Models\MakeAndModel;
use App\Models\Manufacturer;
use App\Models\PurchaseOrder;
use App\Models\TechnicalSpecs;
use App\Models\UserType;
use App\Models\Vendor;
use App\User;

class BulkUpload
{
    protected $charactersToBeReplaced = ['?' => '•'];

    public function getLocationId($item, $dbField, $fileHeader)
    {
        $location = null;
        if (!empty($item[$fileHeader])) {
            $locationName = $item[$fileHeader];
            $locationName = str_replace('"', '', $locationName);
            $split0 = explode("(", $locationName);
            $locationName = trim($split0[0]);
            $location = Location::where('room_name', trim($locationName))->orWhere('room_name', $item[$fileHeader])->first();
        }
        $locationId = $location ? $location->id : null;
        return $locationId;
    }

    public function getAssetTypeId($item, $dbField, $fileHeader)
    {
        $assetType = null;
        if (!empty($item[$fileHeader])) {
            $assetType = AssetType::where('name', trim($item[$fileHeader]))->first();
        }
        $assetTypeId = $assetType ? $assetType->id : null;
        return $assetTypeId;
    }

    public function getManufacturerId($item, $dbField, $fileHeader)
    {
        $manufacturer = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $manufacturer = Manufacturer::where('slug', trim($slug))->first();
        }
        $manufacturerId = $manufacturer ? $manufacturer->id : null;
        return $manufacturerId;
    }

    public function getMakeModelId($item, $dbField, $fileHeader)
    {
        $makeModel = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $manufacturerId = $item['Manufacturer'] ? $item['Manufacturer'] : $this->getManufacturerId($item, 'manufacturer_id', 'Manufacturer');
            $assetTypeId = $item['Asset Type'];
            if ($manufacturerId && $assetTypeId) {
                $makeModel = MakeAndModel::where('slug', trim($slug))
                    ->where('manufacturer_id', $manufacturerId)
                    ->where('asset_type_id', $assetTypeId)
                    ->first();
            }
        }
        $makeModelId = $makeModel ? $makeModel->id : null;
        return $makeModelId;
    }

    public function getAttributeMakeModelId($item, $dbField, $fileHeader)
    {
        $makeModel = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $makeModel = MakeAndModel::where('slug', trim($slug))->first();
        }
        $makeModelId = $makeModel ? $makeModel->id : null;
        return $makeModelId;
    }

    public function getTechnicalSpecId($item, $dbField, $fileHeader)
    {
        $technicalSpec = null;
        if (!empty($item[$fileHeader])) {
            $makeModel = MakeAndModel::where('slug', trim(str_slug($item['Hardware Standard'], '_')))->first();
            $makeModelId = $makeModel ? $makeModel->id : null;
            $technicalSpec = TechnicalSpecs::where('details', trim($item[$fileHeader]))
                ->where('make_and_model_id', $makeModelId)
                ->first();
        }
        $technicalSpecId = $technicalSpec ? $technicalSpec->id : null;
        return $technicalSpecId;
    }

    public function getAttributeTechnicalSpecId($item, $dbField, $fileHeader)
    {
        $technicalSpec = null;
        if (!empty($item[$fileHeader])) {
            $technicalSpec = TechnicalSpecs::where('details', trim($item[$fileHeader]))->first();
        }
        $technicalSpecId = $technicalSpec ? $technicalSpec->id : null;
        return $technicalSpecId;
    }

    public function getCarrierId($item, $dbField, $fileHeader)
    {
        $carrier = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $carrier = Carrier::where('slug', trim($slug))->first();
        }
        $carrierId = $carrier ? $carrier->id : null;
        return $carrierId;
    }

    public function getVendorId($item, $dbField, $fileHeader)
    {
        $vendor = null;
        if (!empty($item[$fileHeader])) {
            $vendor = Vendor::where('name', trim($item[$fileHeader]))->first();
        }
        $vendorId = $vendor ? $vendor->id : $item[$fileHeader];
        return $vendorId;
    }

    public function getParentAssetId($item, $dbField, $fileHeader)
    {
        $parentAsset = null;
        if (!empty($item[$fileHeader])) {
            $parentAsset = Asset::where('serial_no', trim($item[$fileHeader]))->first();
        }
        $parentAssetId = $parentAsset ? $parentAsset->id : null;
        return $parentAssetId;
    }

    public function getPositionId($item, $dbField, $fileHeader)
    {
        $position = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $position = EmployeePosition::firstOrCreate(['slug' => trim($slug)], ['name' => $item[$fileHeader]]);
        }
        $positionId = $position ? $position->id : null;
        return $positionId;
    }

    public function getDepartmentId($item, $dbField, $fileHeader)
    {
        $department = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $department = Department::firstOrCreate(['slug' => trim($slug)], ['name' => $item[$fileHeader]]);
        }
        $departmentId = $department ? $department->id : null;
        return $departmentId;
    }

    public function getEmployeeTypeId($item, $dbField, $fileHeader)
    {
        $employeeType = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $employeeType = EmployeeType::firstOrCreate(['slug' => trim($slug)], ['name' => $item[$fileHeader]]);
        }
        $employeeTypeId = $employeeType ? $employeeType->id : null;
        return $employeeTypeId;
    }


    public function getUserTypeId($item, $dbField, $fileHeader)
    {
        $userType = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $userType = UserType::firstOrCreate(['name' => $item[$fileHeader]]);
        }

        $userTypeId = $userType ? $userType->id : null;
        return $userTypeId;
    }

    public function getIsRehireValue($item, $dbField, $fileHeader)
    {
        if ($item[$fileHeader] == 'Yes') {
            return 1;
        } else {
            return 0;
        }
    }

    public function getNetworkMakeModelId($item, $dbField, $fileHeader)
    {
        $makeModel = null;
        if (!empty($item[$fileHeader])) {
            $slug = str_slug($item[$fileHeader], '_');
            $manufacturerId = $this->getManufacturerId($item, 'manufacturer_id', 'Manufacturer');
            $assetTypeId = $item['Asset Type'];
            if ($manufacturerId && $assetTypeId) {
                $makeModel = MakeAndModel::where('slug', trim($slug))
                    ->where('manufacturer_id', $manufacturerId)
                    ->where('asset_type_id', $assetTypeId)
                    ->first();
            }
        }
        $makeModelId = $makeModel ? $makeModel->id : null;
        return $makeModelId;
    }

    public function getCountryId($item, $dbField, $fileHeader)
    {
        $country = null;
        if (!empty($item[$fileHeader])) {
            $country = Country::where('name', trim($item[$fileHeader]))->first();
        }
        $countryId = $country ? $country->id : null;
        return $countryId;
    }

    public function getStatus($item, $dbField, $fileHeader)
    {
        $status = 0;
        if (!empty($item[$fileHeader])) {
            if (strtoupper(trim($item[$fileHeader])) == 'TRUE') {
                $status = 1;
            }
        }
        return $status;
    }

    public function getUserId($item, $dbField, $fileHeader)
    {
        $user = null;
        if (!empty($item[$fileHeader])) {
            $user = User::where('email', trim($item[$fileHeader]))->first();
        }
        $userId = $user ? $user->id : null;

        return $userId;
    }

    public function getStatusId($item, $dbField, $fileHeader)
    {
        $status = null;
        if (!empty($item[$fileHeader])) {
            $status = AssetStatus::where('slug', trim(str_slug($item[$fileHeader], '_')))->first();
        }
        $statusId = $status ? $status->id : null;
        return $statusId;
    }

    public function getLegalHold($item, $dbField, $fileHeader)
    {
        $status = 1;
        if (!empty($item->$fileHeader)) {
            if (strtoupper(trim($item->$fileHeader)) == 'FALSE' || strtoupper(trim($item->$fileHeader)) == '' || strtoupper(trim($item->$fileHeader)) == 0) {
                $status = 0;
            }
        }
        return $status;
    }

    public function getPurchaseOrderId($item, $dbField, $fileHeader)
    {
        $purchaseOrder = null;
        if (!empty($item[$fileHeader])) {
            $purchaseOrder = PurchaseOrder::where('number', trim(str_slug($item[$fileHeader], '_')))->first();
        }
        $purchaseOrderId = $purchaseOrder ? $purchaseOrder->id : null;
        return $purchaseOrderId;
    }

    public function formatPhoneNumber($carrierId, $assetTag)
    {
        $carrier = Carrier::find($carrierId)->name;
        $assetTag = preg_replace('/\D+/', '', $assetTag);

        if ($carrier == "AT&T" || $carrier == "Verizon" || $carrier == "T-Mobile" || $carrier == "Sprint") {
            return formatUSPhoneNumbers($assetTag);
        }

        if ($carrier == "Telcel") {
            return formatMexicoPhoneNumbers($assetTag);
        }

        if ($carrier == "Vivo") {
            return formatBrazilPhoneNumbers($assetTag);
        }

        if ($carrier == "Airtel") {
            return formatIndianPhoneNumbers($assetTag);
        }

        if ($carrier == "KPN") {
            return formatNetherLandsPhoneNumbers($assetTag);
        }

        if ($carrier == "Vodafone UK") {
            return formatUKPhoneNumbers($assetTag);
        }

        if ($carrier == "Rogers") {
            return formatCanadaPhoneNumbers($assetTag);
        }

        if ($carrier == "Singtel") {
            return formatSingaporePhoneNumbers($assetTag);
        }

        if ($carrier == "SFR") {
            return formatFrancePhoneNumbers($assetTag);
        }

        if ($carrier == "Telstra") {
            return formatAustraliaPhoneNumbers($assetTag);
        }

        return $assetTag;
    }

    public function getAssetTrackingId($item, $dbField, $fileHeader)
    {
        $asssetTrackingId = "";

        if (!empty($item[$fileHeader])) {
            $asssetTrackingId = AssetTracking::firstOrCreate(['tracking_number' => trim($item[$fileHeader])], ['tracking_number' => trim($item[$fileHeader])])->id ?? '';
        }

        return $asssetTrackingId;
    }
}
