<?php

namespace App\Repositories;

use App\Models\Country;
use App\Models\EmployeePosition;
use App\Models\Department;
use App\Models\EmployeeType;

class AzureDirectoryRepository
{
    /**
     * Taking the Posistion based on the API Response
     *
     * @param String $name
     */
    public function getPositionId($name)
    {
        if ($name && !empty($name)) {
            $slug       = str_slug($name, '_');
            $position = EmployeePosition::firstOrCreate(['name' => trim($name)], ['slug'  => trim($slug)]);

            return $position ? $position->id : null;
        }

        return null;
    }


    /**
     * Taking the Department based on the API Response
     *
     * @param String $name
     */
    public function getDepartmentId($name)
    {
        if ($name && !empty($name)) {
            $department = Department::firstOrCreate(['name' => trim($name)]);

            return $department ? $department->id : null;
        }

        return null;
    }


    /**
     * Taking the Country based on the API Response
     *
     * @param String $name
     */
    public function getCountryId($name)
    {
        if ($name && !empty($name)) {
            $country = Country::select('id')->where('name', $name)->first();

            return $country ? $country->id : null;
        }

        return null;
    }


    /**
     * Taking the Employee Type based on the API Response
     *
     * @param String $name
     */
    public function getEmployeeTypeId($name)
    {
        if ($name && !empty($name)) {
            $employeeType = EmployeeType::firstOrCreate(['name' => trim($name)], ['slug' => str_slug(trim($name), '_')]);

            return $employeeType ? $employeeType->id : null;
        }

        return null;
    }
    
}