<?php

namespace App\Repositories;

use App\Models\AssetHealthCategory;
use App\Models\AssetHealthHistory;
use App\Models\AssetHealthTests;

/**
 * AssetsHealthHistory - Repository for asset health history.
 */
class AssetHealthHistoryRepository
{
    /**
     * get total count of issues of assets by week.
     * Get total issues from asset_health_reports table for each sync by week
     * Filter by category and tests if requested
     *
     * @param int $year
     *
     * @return array $resultData
     */
    public function getAssetHealthReportDataInWeek($data)
    {
        $query = AssetHealthHistory::select(
            \DB::raw("DATE(asset_health_histories.started_at) as weekDate"),
            \DB::raw('WEEK(asset_health_histories.started_at, 1) as weekDay'),
            \DB::raw('sum(test_count) as totalIssues'),
        )
        ->join('asset_health_reports', function($join)
        {
            $join->on('asset_health_reports.history_id', '=', 'asset_health_histories.id');
        })
        ->where('asset_health_histories.started_at', '>', $data['dateFrom'])
		->where('asset_health_histories.ended_at', '<', $data['dateTo'])
        ->whereIn('asset_health_histories.id', function($q){
            $q->select(\DB::raw('MAX(id) FROM asset_health_histories GROUP BY WEEK(created_at)'));
        })
        ->groupBy('asset_health_histories.id');
        if($data['testId'] != null){
            $query->where('asset_health_reports.test_id',$data['testId']);
        }
        if($data['categoryId'] != null){
            $query->where('asset_health_reports.category_id',$data['categoryId']);
        }
        return $query->get();
    }

    public function getTest($testId)
    {
        return AssetHealthTests::where('id', $testId)->select('test_name', 'slug', 'id')->first();
    }

    public function getCategory($categoryId)
    {
        return AssetHealthCategory::where('id', $categoryId)->select('category_name', 'slug', 'id')->first();
    }
}
