<?php

namespace App\Repositories\Asn;

use App\Models\AsnHardwareMapping;
use App\Models\AsnAccessoriesMapping;
use App\Repositories\Asn\AsnAssetsRepository;

class PresidioAssetsRepository extends AsnAssetsRepository
{

    /**
     * Get Presidio Accessories mapping data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingData()
    {
        return AsnAccessoriesMapping::query()
            ->leftJoin('make_and_models', 'asn_accessories_mappings.make_and_model_id', '=', 'make_and_models.id')
            ->leftJoin('manufacturers', 'manufacturers.id', '=', 'make_and_models.manufacturer_id')
            ->where('asn_accessories_mappings.provider', 'presidio')
            ->orderBy('asn_accessories_mappings.part_no')
            ->select('asn_accessories_mappings.id as id', 'asn_accessories_mappings.part_no', 'manufacturers.name as manufactureName', 'make_and_models.name as makeAndModelName');
    }

    /**
     * Get Presidio hardware mapping data
     *
     * @return Eloquent
     */
    public function getHardwareMappingData()
    {
        return AsnHardwareMapping::query()
            ->leftJoin('make_and_models', 'asn_hardware_mappings.make_and_model_id', '=', 'make_and_models.id')
            ->leftJoin('technical_specs', 'asn_hardware_mappings.technical_spec_id', '=', 'technical_specs.id')
            ->leftJoin('manufacturers', 'manufacturers.id', '=', 'make_and_models.manufacturer_id')
            ->leftJoin('asset_types', 'asset_types.id', '=', 'make_and_models.asset_type_id')
            ->where('asn_hardware_mappings.provider', 'presidio')
            ->orderBy('asn_hardware_mappings.part_no')
            ->select('asn_hardware_mappings.id as id', 'asn_hardware_mappings.part_no', 'asset_types.name as assetName', 'asset_types.id as assetType', 'manufacturers.name as manufactureName', 'make_and_models.name as makeAndModelName', 'make_and_models.id as makeAndModelId', 'technical_specs.details as details', 'technical_specs.id as technical_spec_id');
    }
}
