<?php

namespace App\Repositories\Asn;

use App\Models\Asset;
use App\Models\AssetStatus;
use App\Repositories\Asn\AsnAssetsRepository;
use Illuminate\Support\Facades\DB;

class ConnectionRepository extends AsnAssetsRepository
{

    /**
     * getAccessoriesMappingData
     *
     * @return object
     */
    public function getAccessoriesMappingData()
    {
        return DB::table('asn_accessories_mappings')
            ->leftjoin('make_and_models', 'asn_accessories_mappings.make_and_model_id', '=', 'make_and_models.id')
            ->leftjoin('manufacturers', 'manufacturers.id', '=', 'make_and_models.manufacturer_id')
            ->where('provider', 'connection')
            ->orderBy('asn_accessories_mappings.part_no')
            ->select('asn_accessories_mappings.id as id', 'asn_accessories_mappings.part_no', 'manufacturers.name as manufactureName', 'make_and_models.name as makeAndModelName');
    }

    /**
     * get Connection HardwareMappingData
     *
     * @return object
     */
    public function getHardwareMappingData()
    {
        return DB::table('asn_hardware_mappings')
            ->leftjoin('make_and_models', 'asn_hardware_mappings.make_and_model_id', '=', 'make_and_models.id')
            ->leftjoin('technical_specs', 'asn_hardware_mappings.technical_spec_id', '=', 'technical_specs.id')
            ->leftjoin('manufacturers', 'manufacturers.id', '=', 'make_and_models.manufacturer_id')
            ->leftjoin('asset_types', 'asset_types.id', '=', 'make_and_models.asset_type_id')
            ->where('provider', 'connection')
            ->orderBy('asn_hardware_mappings.part_no')
            ->select('asn_hardware_mappings.id as id', 'asn_hardware_mappings.part_no', 'asset_types.name as assetName', 'asset_types.id as assetType', 'manufacturers.name as manufactureName', 'make_and_models.name as makeAndModelName', 'make_and_models.id as makeAndModelId', 'technical_specs.details as details', 'technical_specs.id as technical_spec_id');
    }
}
