<?php

namespace App\Repositories\Asn;

use Illuminate\Http\Request;
use App\Models\Asset;
use App\Models\AssetStatus;
use DB;


abstract class AsnAssetsRepository
{
    abstract protected function getAccessoriesMappingData();
    abstract protected function getHardwareMappingData();
    /**
     * Query for ASN assets list
     */
    public function getAssets($statusSlug)
    {
        $assets = Asset::with('assetType', 'makeAndModel', 'makeAndModel.manufacturer', 'technicalSpec', 'assetStatus', 'assetTracking')
            ->whereHas('assetStatus', function ($query) use ($statusSlug) {
                $query->where('slug', '=', $statusSlug);
            });

        return $assets;
    }

    /**
     * Filter with Asset Tracking Fields
     *
     * @param $query
     * @param $value
     * @param $field
     *
     * @return Query
     */
    public function filterWithTracking($query, $value, $field)
    {
        if ($value) {
            $query = $query->whereHas('assetTracking', function ($query) use ($value, $field) {
                if (is_array($value)) {
                    $query->whereIn($field, $value);
                } else {
                    $query->where($field, $value);
                }
            });
        }

        return $query;
    }
    /**
     * Filter with Asset Tracking Fields
     *
     * @param $query
     * @param $value
     * @param $field
     *
     * @return Query
     */
    public function filterAsnLogin($query, $value, $field)
    {
        if (!$value) {
            return $query;
        }
        if ($value == 1) {
            return $query->where(function ($user) {
                $user->whereNotNull('user_id')
                    ->Where('user_id', '>', 0);
            });
        } else if ($value == 0) {
            return $query->where(function ($user) {
                $user->whereNull('user_id')
                    ->Where('user_id', 0);
            });
        }
    }

    public function filterWithEmail($query, $value, $field)
    {
        if (!$value) {
            return $query;
        }
        return  $query->whereHas('airwatch', function ($query) use ($value) {
            $query->Where('email', 'like', $value . '%');
        });
    }

    public function filterByPo($query, $value)
    {
        if (!$value) {
            return $query;
        }
        return  $query->Where('po_id', 'like', $value . '%');
    }

    /**
     * Filter data query
     * @param mixed $hardwareMappingData
     * @param null $makeAndModel
     * @param null $technicalSpec
     * @param null $searchText
     *
     * @return Eloquent
     */
    public function filterHardwareMapping($hardwareMappingData, $makeAndModel = null, $technicalSpec = null, $searchText = null)
    {
        if ($makeAndModel) {
            $hardwareMappingData = $hardwareMappingData->whereIn('asn_hardware_mappings.make_and_model_id', $makeAndModel);
        }

        if ($technicalSpec) {
            $hardwareMappingData = $hardwareMappingData->whereIn('asn_hardware_mappings.technical_spec_id', $technicalSpec);
        }

        if ($searchText) {
            $hardwareMappingData = $hardwareMappingData->where('asn_hardware_mappings.part_no', 'like', '%' . $searchText . '%');
        }

        return  $hardwareMappingData;
    }
}
