<?php

namespace App\Repositories;

use App\Models\ApiCredential;

class ApiCredentialRepository
{
    protected $apiCredentialModel;

    /**
     * Construstor for ApiCredentialRepository
     *
     * @param ApiCredential $apiCredentialModel
     */
    public function __construct(ApiCredential $apiCredentialModel)
    {
        $this->apiCredentialModel = $apiCredentialModel;
    }

    /**
     * get credentials for the API
     *
     * @param string $slug slug of the api
     *
     * @return mixed
     */
    public function getCredentials($slug)
    {
        return $this->apiCredentialModel::where('slug', $slug)->first();
    }

    /**
     * add credentials for the API
     *
     * @param array $data
     * @param string $slug
     * @param string $name
     *
     * @return void
     */
    public function addCredentials($data, $slug, $name)
    {
        $this->apiCredentialModel::create([
            'api_name'  => $name,
            'slug'      => $slug,
            'user_name' => $data['app_name'] ?? null,
            'key'       => $data['app_key'] ?? null,
            'password'  => $data['app_secret'] ?? null
        ]);
    }

    /**
     * add credentials for the API
     *
     * @param array $data
     * @param string $slug
     *
     * @return void
     */
    public function updateCredentials($data, $slug)
    {
        $this->apiCredentialModel->where('slug', $slug)->update($data);
    }

    /**
     * Create a new api credential
     *
     * @param array $data "Array of data to insert into api credentials"
     *
     * @return ApiCredential
     */
    public function create(array $data)
    {
        return $this->apiCredentialModel->create($data);
    }

    /**
     * Get the API Credential by id
     *
     * @param int $id "API Credential Id"
     *
     * @return ApiCredential
     */
    public function findById(int $id)
    {
        return $this->apiCredentialModel->findOrFail($id);
    }
}
