<?php

namespace App\Repositories\Api;

use Illuminate\Database\Eloquent\Builder;
use App\Models\Vendor;

/**
 * Repository class for the Vendors API
 */
class VendorApiRepository extends AbstractApiRepository
{
    private $vendor;

    /**
     * Constructor
     *
     * @param Vendor $vendor
     */
    public function __construct(Vendor $vendor)
    {
        $this->vendor = $vendor;
    }
    /**
     * Retrieves all vendors from the database.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function getVendors()
    {
        return $this->getVendorQuery();
    }

    /**
     * Search through vendors with general queries.
     *
     * @param \Illuminate\Database\Eloquent\Builder $vendor
     * @param string|null $search
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function searchVendorsWithGeneralQueries(Builder $vendor, ?string $search)
    {
        return $search ? $vendor->where('name', 'like', $search . '%') : $vendor;
    }

    /**
     * Retrieves the necessary columns from the Vendor model.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    private function getVendorQuery()
    {
        return $this->vendor->select('id', 'name', 'created_at', 'updated_at');
    }
}
