<?php

namespace App\Repositories\Api;


use App\User;

/**
 * repository class for the User API
 */
class UserApiRepository extends AbstractApiRepository
{
	/**
	 * Get all user
	 */
	public function getUsers()
	{
		return User::superAdmin()->with(['userType', 'employeeType', 'department', 'position', 'location']);
	}


	/**
	 * simple search throgh users
	 * @param mixed $users
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchUsersWithGeneralQueries($users, $search)
	{
		if ($search == '') {
			return $users;
		}

		foreach (config('api-filter-fields.users.filter_fields') as $key => $value) {
			if ($key == 0) {
				$users->where($value, 'like', $search . '%');
			} else {
				$users->orWhere($value, 'like', $search . '%');
			}
		}

		foreach (config('api-filter-fields.users.filter_mapping_fields') as $key => $value) {
			if ($key == 0) {
				$users->where($value, 'like', $search . '%');
			} else {
				$users->orWhere($value, 'like', $search . '%');
			}
		}

		foreach (config('api-filter-fields.users.relational_filter_fields') as $key => $value) {

			$users->orWhereHas($value['relation'], function ($query) use ($search, $value) {
				$query->where($value['db_field'], 'like', '%' . $search . '%');
			});
		}

		// dd($users->toSql());
		return $users;
	}
}
