<?php

namespace App\Repositories\Api;

use App\Models\TechnicalSpecs;

/**
 * repository class for the TechSpec API
 */
class TechSpecApiRepository extends AbstractApiRepository
{
	/**
	 * Get all techSpec
	 */
	public function getTechSpecs()
	{
		return TechnicalSpecs::with(['makeAndModel', 'makeAndModel.manufacturer', 'makeAndModel.assetType']);
	}

	/**
	 * simple search throgh techSpecs
	 * @param mixed $techSpecs
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchTechSpecsWithGeneralQueries($techSpecs, $search)
	{
		if ($search == '') {
			return $techSpecs;
		}
		foreach (config('api-filter-fields.techSpecs.filter_fields') as $key => $value) {
			if ($key == 0) {
				$techSpecs->where($value, 'like', $search . '%');
			} else {
				$techSpecs->orWhere($value, 'like', $search . '%');
			}
		}

		foreach (config('api-filter-fields.techSpecs.relational_filter_fields') as $key => $value) {

			$techSpecs->orWhereHas($value['relation'], function ($query) use ($search, $value) {
				$query->where($value['db_field'], 'like', '%' . $search . '%');
			});
		}


		return $techSpecs;
	}
}
