<?php

namespace App\Repositories\Api;

use Illuminate\Database\Eloquent\Builder;
use App\Models\SiteCode;

/**
 * Repository class for the Site Code API
 */
class SiteCodeApiRepository extends AbstractApiRepository
{
	private $siteCode;

    /**
     * Constructor
     *
     * @param SiteCode $siteCode
     */
    public function __construct(SiteCode $siteCode)
    {
        $this->siteCode = $siteCode;
    }
	/**
	 * Retrieves all siteCodes from the database.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function getSiteCodes()
	{
		return $this->getSiteCodeQuery();
	}

	/**
	 * Search through Site Codes with general queries.
	 *
	 * @param \Illuminate\Database\Eloquent\Builder $siteCode
	 * @param string|null $search
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function searchSiteCodesWithGeneralQueries(Builder $siteCode, ?string $search)
	{
		return $search ? $siteCode->where('code', 'like', $search . '%') : $siteCode;
	}

	/**
	 * Retrieves the necessary columns from the SiteCode model.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	private function getSiteCodeQuery()
	{
		return $this->siteCode->with(['country', 'region'])->select('id', 'code', 'country_id', 'region_id', 'created_at', 'updated_at');
	}
}
