<?php

namespace App\Repositories\Api;

use Illuminate\Database\Eloquent\Builder;
use App\Models\Carrier;

/**
 * Repository class for the Asset Status API 
 */
class MobileCarrierApiRepository extends AbstractApiRepository
{
	private $mobileCarrier;

    /**
     * Constructor
     *
     * @param Carrier $mobileCarrier
     */
    public function __construct(Carrier $mobileCarrier)
    {
        $this->mobileCarrier = $mobileCarrier;
    }
	/**
	 * Retrieves all mobileCarriers from the database.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function getMobileCarriers()
	{
		return $this->getMobileCarrierQuery();
	}

	/**
	 * Search through mobile carriers with general queries.
	 *
	 * @param \Illuminate\Database\Eloquent\Builder $mobileCarrier
	 * @param string|null $search
	 * 
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function searchMobileCarriersWithGeneralQueries(Builder $mobileCarrier, ?string $search)
	{
		return $search ? $mobileCarrier->where('name', 'like', $search . '%') : $mobileCarrier;
	}

	/**
	 * Retrieves the necessary columns from the MobileCarrier model.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	private function getMobileCarrierQuery()
	{
		return $this->mobileCarrier->with('country')->select('id', 'name', 'country_id', 'created_at', 'updated_at');
	}
}
