<?php

namespace App\Repositories\Api;

use App\Models\Manufacturer;

/**
 * Repository class for the Manufacturer API
 */
class ManufacturerApiRepository extends AbstractApiRepository
{
	/**
	 * Get all manufacturers
	 */
	public function getManufacturers()
	{
		return Manufacturer::select('id', 'name', 'created_at', 'updated_at');
	}

	/**
	 * simple search throgh manufacturers
	 * @param mixed $manufacturers
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchManufacturersWithGeneralQueries($manufacturers, $search)
	{
		if ($search) {
			$manufacturers->where('name', 'like', $search . '%');
		}

		return $manufacturers;
	}
}
