<?php

namespace App\Repositories\Api;

use Illuminate\Database\Eloquent\Builder;
use App\Models\LocationType;

/**
 * Repository class for the Location Type API 
 */
class LocationTypeApiRepository extends AbstractApiRepository
{
	private $locationType;

    /**
     * Constructor
     *
     * @param LocationType $locationType
     */
    public function __construct(LocationType $locationType)
    {
        $this->locationType = $locationType;
    }
	/**
	 * Retrieves all locationTypes from the database.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function getLocationTypes()
	{
		return $this->getLocationTypeQuery();
	}

	/**
	 * Search through locationTypes with general queries.
	 *
	 * @param \Illuminate\Database\Eloquent\Builder $locationType
	 * @param string|null $search
	 * 
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	public function searchLocationTypesWithGeneralQueries(Builder $locationType, ?string $search)
	{
		return $search ? $locationType->where('location_type_name', 'like', $search . '%') : $locationType;
	}

	/**
	 * Retrieves the necessary columns from the LocationType model.
	 *
	 * @return \Illuminate\Database\Eloquent\Builder
	 */
	private function getLocationTypeQuery()
	{
		return $this->locationType->select('id', 'location_type_name', 'created_at', 'updated_at');
	}
}
