<?php

namespace App\Repositories\Api;

use App\Models\Location;

/**
 * repository class for the Location API
 */
class LocationApiRepository extends AbstractApiRepository
{
	/**
	 * Get all location
	 */
	public function getLocations()
	{
		return Location::with(['siteCode:id,code,country_id,region_id', 'siteCode.country:id,name', 'siteCode.region:id,name', 'locationType']);
	}


	/**
	 * simple search throgh locations
	 * @param mixed $locations
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchLocationsWithGeneralQueries($locations, $search)
	{

		if (!$search || $search == '') {
			return $locations;
		}
		foreach (config('api-filter-fields.locations.filter_fields') as $key => $value) {
			if ($key == 0) {
				$locations->where($value, 'like', $search . '%');
			} else {
				$locations->orWhere($value, 'like', $search . '%');
			}
		}

		foreach (config('api-filter-fields.locations.relational_filter_fields') as $key => $value) {

			$locations->orWhereHas($value['relation'], function ($query) use ($search, $value) {
				$query->where($value['db_field'], 'like', '%' . $search . '%');
			});
		}



		return $locations;
	}
}
