<?php

namespace App\Repositories\Api;

use App\Models\MakeAndModel;

/**
 * repository class for the HardwareStandard API
 */
class HardwareStandardApiRepository extends AbstractApiRepository
{
	/**
	 * Get all hardwareStandard
	 */
	public function getHardwareStandards()
	{
		return MakeAndModel::with(['manufacturer', 'assetType']);
	}

	/**
	 * simple search throgh hardwareStandards
	 * @param mixed $hardwareStandards
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchHardwareStandardsWithGeneralQueries($hardwareStandards, $search)
	{
		if (!$search || $search == '') {
			return $hardwareStandards;
		}
		foreach (config('api-filter-fields.hardwareStandards.filter_fields') as $key => $value) {
			if ($key == 0) {
				$hardwareStandards->where($value, 'like', $search . '%');
			} else {
				$hardwareStandards->orWhere($value, 'like', $search . '%');
			}
		}

		foreach (config('api-filter-fields.hardwareStandards.relational_filter_fields') as $key => $value) {

			$hardwareStandards->orWhereHas($value['relation'], function ($query) use ($search, $value) {
				$query->where($value['db_field'], 'like', '%' . $search . '%');
			});
		}


		return $hardwareStandards;
	}
}
