<?php

namespace App\Repositories\Api;

use App\Models\AssetType;

/**
 * repository class for the HardwareStandard API
 */
class AssetTypeApiRepository extends AbstractApiRepository
{
	/**
	 * Get all hardwareStandard
	 */
	public function getAssetTypes()
	{
		return AssetType::select('id', 'name', 'parent','created_at', 'updated_at');
	}

	/**
	 * simple search throgh assetTypes
	 * @param mixed $assetTypes
	 * @param mixed $search
	 *
	 * @return [type]
	 */
	public function searchAssetTypesWithGeneralQueries($assetTypes, $search)
	{
		if ($search) {
			$assetTypes->where('name', 'like', $search . '%');
		}

		return $assetTypes;
	}
}
