<?php

namespace App\Repositories\Api;

use App\Models\AssetStatus;

/**
 * Repository class for the Asset Status API 
 */
class AssetStatusApiRepository extends AbstractApiRepository
{
	/**
	 * Get all hardwareStandard
	 */
	public function getAssetStatus()
	{
		return AssetStatus::select('id', 'name', 'created_at', 'updated_at');
	}

	/**
	 * simple search throgh asset status 
	 * @param mixed $assetStatus
	 * @param mixed $search
	 * 
	 * @return [type]
	 */
	public function searchAssetStatusWithGeneralQueries($assetStatus, $search)
	{
		if ($search) {
			$assetStatus->where('name', 'like', $search . '%');
		}

		return $assetStatus;
	}
}
