<?php

namespace App\Repositories\Api;


/**
 * repository class for the User API
 */
class AbstractApiRepository
{
	/**
	 * Generel function to filter field
	 * @param mixed $assets
	 * @param mixed $search
	 * @param mixed $model
	 * @param mixed $field
	 *
	 * @return [type]
	 */
	public function filterByDirectFields($assets, $search, $field)
	{
		if (empty($search)) {
			return $assets;
		}
		if (($key = array_search('', $search)) !== false) {
			unset($search[$key]);
		}


		return $assets->where(function ($query) use ($search, $field) {
			foreach ($search as $key => $element) {
				if ($key == 0) {
					$query->where($field, 'like', '%' . $element . '%');
				} else {
					$query->orWhere($field, 'like', '%' . $element . '%');
				}
			}
		});
	}

	/**
	 * Generel function to filter model based
	 * @param mixed $assets
	 * @param mixed $search
	 * @param mixed $model
	 * @param mixed $field
	 *
	 * @return [type]
	 */
	public function filterByDateFields($assets, $search, $field)
	{
		if (empty($search)) {
			return $assets;
		}
		if (($key = array_search('', $search)) !== false) {
			unset($search[$key]);
		}
		return $assets->where(function ($query) use ($search, $field) {
			foreach ($search as $key => $element) {
				if ($key == 0) {
					$query->whereDate($field, convert_to_db_date($element));
				} else {
					$query->orWhereDate($field, convert_to_db_date($element));
				}
			}
		});
	}

	/**
	 * Generel function to filter model based
	 * @param mixed $assets
	 * @param mixed $search
	 * @param mixed $model
	 * @param mixed $field
	 *
	 * @return [type]
	 */
	public function filterByRelatedModelFields($assets, $search, $model, $field)
	{

		if (empty($search)) {
			return $assets;
		}
		if (($key = array_search('', $search)) !== false) {
			unset($search[$key]);
		}
		return $assets->whereHas($model, function ($query) use ($search, $field) {
			foreach ($search as $key => $element) {
				if ($key == 0) {
					$query->where($field, 'like', '%' . $element . '%');
				} else {
					$query->orWhere($field, 'like', '%' . $element . '%');
				}
			}
		});
	}


	/**
	 * Generel function to filter model based dates
	 * @param mixed $assets
	 * @param mixed $search
	 * @param mixed $model
	 * @param mixed $field
	 *
	 * @return [type]
	 */
	public function filterByRelationalDateFields($assets, $search, $model, $field)
	{
		if (!empty($search)) {
			return $assets;
		}
		if (($key = array_search('', $search)) !== false) {
			unset($search[$key]);
		}
		return $assets->whereHas($model, function ($query) use ($search, $field) {
			foreach ($search as $key => $element) {
				if ($key == 0) {
					$query->whereDate($field, convert_to_db_date($element));
				} else {
					$query->orWhereDate($field, convert_to_db_date($element));
				}
			}
		});
	}
}
