<?php

namespace App\Providers;

use App\Models\OAuthScope;
use Illuminate\Support\ServiceProvider;
use Laravel\Passport\Passport;
use Illuminate\Support\Facades\Schema;

class PassportServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        if (Schema::hasTable('oauth_scopes')) {
            $scopes = OAuthScope::pluck('description', 'slug')->toArray();

            Passport::tokensCan($scopes);
        }
    }
}
