<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\DB;
use Config;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Schema;

class OktaSsoConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $oktaSSO = Cache::remember('okta_sso_config', 120, function () {
            return DB::table('api_credentials')->where('slug', 'okta_sso')->where('integration_status', 1)->first();
        });

        if ($oktaSSO) {
            $saml2Config = config('saml2_settings');

            $saml2Config['idp']['entityId'] = $oktaSSO->url;
            $saml2Config['idp']['singleSignOnService']['url'] = $oktaSSO->user_name;
            $saml2Config['idp']['singleLogoutService']['url'] = $oktaSSO->project;
            $saml2Config['idp']['x509cert'] = $oktaSSO->data;

            Config::set('saml2_settings', $saml2Config);
        }
        
    }
}
