<?php

namespace App\Providers;

use App\Models\Asset;
use Illuminate\Support\Facades\Event;
use App\Observers\AssetObserver;
use App\Observers\UserObserver;
use App\User;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'Aacotroneo\Saml2\Events\Saml2LoginEvent' => [
            'App\Listeners\Saml2LoginListener',
        ],
        'Aacotroneo\Saml2\Events\Saml2LogoutEvent' => [
            'App\Listeners\Saml2LogoutListener',
        ],
        'App\Events\PurchaseIndicator' => [
            'App\Listeners\SendPurchaseIndicatorNotification',
        ],
        'App\Events\LogFailedAuthentication' => [
            'App\Listeners\LogFailedAuthenticationAttempt',
        ],
        'App\Events\ResetPasswordEmailFailed' => [
            'App\Listeners\ResetPasswordEmailFailedAttempt',
        ],
        'App\Events\UpdateAssetStatus' => [
            'App\Listeners\UpdateTicket',
            'App\Listeners\CreateAssetHistory',
        ],
        'App\Events\BulkUpdateTicket' => [
            'App\Listeners\BulkUpdateTicket'
        ],
        'App\Events\BulkUpdates' => [
            'App\Listeners\BulkCreateAssetHistory'
        ],
        'App\Events\CreateApiRequestHistory' => [
            'App\Listeners\CreateApiRequestHistory'
        ],
        'SocialiteProviders\Manager\SocialiteWasCalled' => [
            'SocialiteProviders\Okta\OktaExtendSocialite',
        ],
        'App\Events\UpdateShipmentStatus' => [
            'App\Listeners\UpdateShipmentStatus'
        ],
        'App\Events\UpdateShiShipmentStatus' => [
            'App\Listeners\UpdateShiShipmentStatus'
        ],
        'App\Events\UserCreated' => [
            'App\Listeners\AssignRole',

        ],
        'App\Events\IntegrationSyncHistory' => [
            'App\Listeners\CreateIntegrationSyncHistory',
        ],
        'Illuminate\Auth\Events\Login' => [
            'App\Listeners\LoginSuccessfulListener',
        ],

        // To perform additional/custom actions after a password reset
        'Illuminate\Auth\Events\PasswordReset' => [
            'App\Listeners\AdditionalPasswordResetActions',
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        Asset::observe(AssetObserver::class);
        User::observe(UserObserver::class);
    }
}
