<?php

namespace App\Providers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\ServiceProvider;

class AzureSsoConfigServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        
        $azureSSO = Cache::remember('azure_sso_config', 120, function () {
            return DB::table('api_credentials')->where('slug', 'azure_sso')->where('integration_status', 1)->first();
        });
        
        if ($azureSSO) {
            $saml2Config = config('saml2_settings');

            $saml2Config['idp']['entityId'] = $azureSSO->url;
            $saml2Config['idp']['singleSignOnService']['url'] = $azureSSO->user_name;
            $saml2Config['idp']['singleLogoutService']['url'] = $azureSSO->project;
            $saml2Config['idp']['x509cert'] = $azureSSO->data;

            Config::set('saml2_settings', $saml2Config);
        }
        
    }
}