<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        // Conditionally add ModelPolicy if the class exists
        if (class_exists('App\Policies\ModelPolicy')) {
            $this->policies['App\Model'] = 'App\Policies\ModelPolicy';
        }

        $this->registerPolicies();

        // Passport::tokensExpireIn(now()->addYears(5));
        // Passport::refreshTokensExpireIn(now()->addYears(5));
        // Passport::personalAccessTokensExpireIn(now()->addYears(5));
    }
}
