<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App\Models\MakeAndModel;
use App\Observers\MakeAndModelObserver;
use League\Flysystem\Filesystem;
use League\Flysystem\Sftp\SftpAdapter;
use Illuminate\Pagination\Paginator;
use App\Services\Integrations\Tickets\TicketIntegrationInterface;
use App\Services\Integrations\Tickets\Zendesk\ZendeskIntegration;
use App\Services\Integrations\Tickets\FreshService\FreshServiceIntegration;
use App\Services\Integrations\Tickets\Jira\JiraIntegration;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if (config('app.env') != 'local') {
            URL::forceScheme('https');
        }
        Schema::defaultStringLength(191);
        Paginator::useBootstrap();
        MakeAndModel::observe(MakeAndModelObserver::class);
        Storage::extend('sftp', function ($app, $config) {
            return new Filesystem(new SftpAdapter($config));
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $ticketInegrationClassName = config('ticket-integration.service', null);
        $ticketIntegration = match ($ticketInegrationClassName) {
            'Jira' => JiraIntegration::class,
            'Zendesk' => ZendeskIntegration::class,
            'FreshService' => FreshServiceIntegration::class,
            'ServiceNow' => ServiceNowIntegration::class,
            default => JiraIntegration::class,
        };

        $this->app->bind(TicketIntegrationInterface::class, $ticketIntegration);
    }
}
