<?php

namespace App\Observers;

use App\Models\Asset;
use Carbon\Carbon;

class AssetObserver
{
    /**
     * Set up default warranty date for newly created assets
     * 
     * @param  \App\Models\Asset  $asset
     * @return void
     */
    public function created(Asset $asset)
    {
        // $years = 1;

        // if ($asset->makeAndModel && $asset->makeAndModel->manufacturer) {

        //     if ($asset->makeAndModel->manufacturer->name == 'Apple') {
        //         $years = 3;
        //     } else {
        //         $years = 1;
        //     }
        // }
        // $warrantyEndDate = !empty($asset->created_at) ? Carbon::parse($asset->created_at)->addYears($years)->format('Y-m-d') : null;
        // $asset->update(['warranty_end_date' => $warrantyEndDate]);
    }

    /**
     * Listen to the Asset updating event.
     *
     * @param  \App\Asset  $asset
     * @return void
     */
    public function updating(Asset $asset)
    {
        if ($asset->isDirty('asset_status_id')) {
            $asset['last_status_update'] = date('Y-m-d H:i:s');
        }
    }
}
