<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\SlackMessage;
use Illuminate\Notifications\Notification;

class TerminatedUsersStillAssignedToAssetsNotification extends Notification
{
    use Queueable;

    protected $message;
    
    /**
     * Create a new notification instance.
     *
     * @param array $message The message
     * 
     * @return void
     */
    public function __construct($message)
    {
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['slack'];
    }


    /**
     * Get the Slack representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\SlackMessage
     */
    public function toSlack($notifiable)
    {
        return (new SlackMessage)
            ->error()
            ->content('')
            ->attachment(function ($attachment) {
                $attachment->title('Terminated users with assets still assigned:')
                    ->fields([
                        '' => $this->message,
                    ])
                    ->footer('Please take necessary actions to address this issue.');
            });
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
