<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class ShareReports extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($fileName, $title)
    {
        $this->file_name = $fileName;
        $this->report_title = $title;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $subjectString ='Report Shared from Teqtivity';
        $filePath  = storage_path('app/public/share_via_email/' . $this->file_name . '.csv');
        return (new MailMessage)
            ->subject($subjectString)
            ->view('emails.report-share', ['title' => $this->report_title])
            ->attach($filePath, [
                'as' => $this->file_name . '.csv',
                'mime' => 'application/csv',
            ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
