<?php

namespace App\Notifications;

use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\AssetHealthHistory;

class AssetsHealthReportNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(protected User $user)
    {
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $latestHistory = AssetHealthHistory::latest()->first();

        if (!$latestHistory) {
            return false;
        }

        $latestHistoryCreatedDate = $latestHistory->created_at->format('Y-m-d');

        $attachmentPath = public_path('reports/'.$latestHistoryCreatedDate.'/report.pdf');

        // Check if the file exists
        if (!file_exists($attachmentPath)) {
            return false;
        }

        return (new MailMessage)->view(
            'emails.send-email-asset-health-report',
            ['user' => $this->user]
        )->attach($attachmentPath, [
            'as' => 'asset-health-report.pdf',
            'mime' => 'application/pdf',
        ])->subject('Teqtivity Asset Health Report');

        return true;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
